/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.util.JavassistUtil;
import org.zeroturnaround.jrebel.liferay.cbp.ConfigurationImplInterface;

public class ConfigurationImplCBP
extends CacheAwareJavassistClassBytecodeProcessor {
    private static final Logger log = LoggerFactory.getInstance().productPrefix("Liferay");

    public void addLogger(CtClass ctClass) throws CannotCompileException {
        ctClass.addField(CtField.make((String)"private static final Logger jrLogger = LoggerFactory.getInstance().productPrefix(\"Liferay\");", (CtClass)ctClass));
    }

    public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
        cp.importPackage("org.zeroturnaround.javarebel");
        this.addLogger(ctClass);
        this.processResources(cp, cl, ctClass);
        this.implementConfigurationImplInterface(cp, cl, ctClass);
    }

    public void processResources(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
        cp.importPackage("java.io");
        cp.importPackage("com.germinus.easyconf");
        CtConstructor[] cs = ctClass.getConstructors();
        for (int i = 0; i < cs.length; ++i) {
            cs[i].instrument(new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    block7: {
                        if ("load".equals(m.getMethodName())) {
                            m.replace("{  InputStream is = (InputStream)$1;  $_ = $proceed($$);  try { if (is!= null) is.close(); } catch( Exception e ) {}}");
                        } else if ("getConfiguration".equals(m.getMethodName())) {
                            try {
                                if (m.getMethod().getParameterTypes().length == 1) {
                                    m.replace("{  StopWatch sw = jrLogger.createStopWatch(\"Liferay#refreshComponentFirst\");   try {    EasyConf.refreshComponent($1);    $_ = $proceed($$);  } finally {    sw.stop();  }}");
                                } else {
                                    m.replace("{  StopWatch sw = jrLogger.createStopWatch(\"Liferay#refreshComponentSecond\");   try {    EasyConf.refreshComponent($1 + $2);    $_ = $proceed($$);  } finally {    sw.stop();  }}");
                                }
                            }
                            catch (NotFoundException e) {
                                if (!log.isEnabled()) break block7;
                                log.error((Throwable)e);
                            }
                        }
                    }
                }
            });
        }
    }

    public void implementConfigurationImplInterface(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
        cp.importPackage("java.util");
        ctClass.addInterface(cp.get(ConfigurationImplInterface.class.getName()));
        boolean hasGetLoadedSources = JavassistUtil.hasDeclaredMethod((CtClass)ctClass, (String)"getLoadedSources");
        log.debug("ConfigurationImpl has getLoadedSources: {}", (Object)hasGetLoadedSources);
        if (hasGetLoadedSources) {
            return;
        }
        if (JavassistUtil.hasDeclaredField((CtClass)ctClass, (String)"_componentProperties")) {
            ctClass.addMethod(CtNewMethod.make((String)"public List getLoadedSources() {   return _componentProperties.getLoadedSources();}", (CtClass)ctClass));
        } else if (JavassistUtil.hasDeclaredField((CtClass)ctClass, (String)"_classLoaderAggregateProperties")) {
            ctClass.addMethod(CtNewMethod.make((String)"public List getLoadedSources() {   return _classLoaderAggregateProperties.loadedSources();}", (CtClass)ctClass));
        } else {
            ctClass.addMethod(CtNewMethod.make((String)"public List getLoadedSources() {   return getComponentProperties().getLoadedSources();}", (CtClass)ctClass));
        }
    }
}

