/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.liferay.util;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;

public class PropertiesWrapper
extends Properties {
    private static final long serialVersionUID = 7590836030263290921L;
    private final WeakReference<ClassLoader> cl;
    private final String name;

    public PropertiesWrapper(Properties properties, ClassLoader cl, String name) {
        if (properties == null || cl == null || name == null) {
            throw new IllegalArgumentException();
        }
        Enumeration<?> propEnum = properties.propertyNames();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            String propValue = properties.getProperty(propName);
            super.setProperty(propName, propValue);
        }
        this.cl = new WeakReference<ClassLoader>(cl);
        this.name = name;
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.cl.get();
    }

    public String getName() {
        return this.name;
    }

    public URL getResource() {
        ClassLoader cl = this.getClassLoader();
        return cl != null ? cl.getResource(this.name + ".properties") : null;
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesWrapper pw = (PropertiesWrapper)o;
        return super.equals(o) && this.name.equals(pw.name) && MiscUtil.objectEquals((Object)this.getClassLoader(), (Object)pw.getClassLoader());
    }

    @Override
    public synchronized int hashCode() {
        ClassLoader cl = this.getClassLoader();
        int hash = super.hashCode();
        hash = 31 * hash + this.name.hashCode();
        hash = 31 * hash + (cl != null ? cl.hashCode() : 0);
        return hash;
    }
}

