/**
 * Copyright (C) 2013 ZeroTurnaround OU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License v2 as published by
 * the Free Software Foundation, with the additional requirement that
 * ZeroTurnaround OU must be prominently attributed in the program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of GNU General Public License v2 from
 *   http://www.gnu.org/licenses/gpl-2.0.txt
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.*;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.LiferayPlugin;

public class DynamicCSSFilterCBP extends CacheAwareJavassistClassBytecodeProcessor {

  private static final String JR_LOGGER =  "LoggerFactory.getLogger(\"" + LiferayPlugin.PRODUCT_PREFIX + "\")";

  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("java.io");

    cp.importPackage("org.zeroturnaround.javarebel");
    cp.importPackage("org.zeroturnaround.jrebel.liferay.util");
    cp.importPackage("com.liferay.portal.servlet.filters.dynamiccss");

    ctClass.addField(CtField.make("private ThemeCssReloader _monitor = null;", ctClass));

    CtMethod method = ctClass.getDeclaredMethod("getDynamicContent");
    method.instrument(new ExprEditor() {
      public void edit(MethodCall m) throws CannotCompileException {
        if ("exists".equals(m.getMethodName())) {
          m.replace("{  " +
              "if (_monitor != null && _monitor.isDirty(requestPath, DynamicCSSFilter.class)) {" +
                  JR_LOGGER + ".echo(\"Regenerating requested CSS resource: \"+requestURI);" +
              "   $_ = false; " +
              "   _monitor.reset(requestPath); " +
              " } else {" +
              "   $_ = $proceed($$); " +
              " } " +
              "}");
        }
      }
    });

    ctClass.getDeclaredMethod("init").insertAfter("{" +
        " if (_servletContext instanceof RebelServletContext " +
        "     && ServletIntegrationFactory.getInstance().hasReplacedResources((RebelServletContext)_servletContext) ) {" +
        "   _monitor = ThemeCssReloader.addToServletContext((RebelServletContext)_servletContext, _servletContext.getContextPath());" +
        " }" +
       "}");
  }
}
