package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.util.JavassistUtil;
import org.zeroturnaround.jrebel.liferay.util.ClassLoaderResourceInputStream;

import java.io.InputStream;
import java.util.ResourceBundle;

/**
 * Transforms {@link com.liferay.portal.language.LiferayResourceBundle}.
 */
public class LiferayResourceBundleCBP extends CacheAwareJavassistClassBytecodeProcessor {
  @Override
  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("org.zeroturnaround.javarebel");
    cp.importPackage("org.zeroturnaround.javarebel.integration.monitor");
    cp.importPackage("org.zeroturnaround.javarebel.integration.util");
    cp.importPackage("java.io");
    cp.importPackage("java.util");
    cp.importPackage("com.liferay.portal.kernel.util");
    cp.importPackage("com.liferay.portal.language");

    ctClass.addField(CtField.make("private MonitoredResource jrMonitoredResource;", ctClass));
    ctClass.addField(CtField.make("private String jrCharsetName;", ctClass));

    CtConstructor constructor = ctClass.getDeclaredConstructor(new CtClass[]{
        cp.get(ResourceBundle.class.getName()),
        cp.get(InputStream.class.getName()),
        cp.get(String.class.getName())});
    constructor.insertAfter(
        "if ($2 instanceof "+ ClassLoaderResourceInputStream.class.getName() +") {" +
        "  "+ClassLoaderResourceInputStream.class.getName()+" is = ("+ClassLoaderResourceInputStream.class.getName()+") $2;" +
        "  jrCharsetName = $3;" +
        "  Integration integration = IntegrationFactory.getInstance();" +
        "  if (integration.isResourceReplaced(is.classLoader, is.resourceName)) {" +
        "    Resource resource = ResourceUtil.asResource(is.classLoader.getResource(is.resourceName));" +
        "    if (resource != null) {" +
        "      jrMonitoredResource = new MonitoredResource(resource);" +
        "    }" +
        "  }" +
        "}" +
        // Looks like Liferay forgets to close this provided inputstream after it reads it.
        "try {" +
        "  $2.close();" +
        "} catch (IOException ex) { }"
    );

    // versions before 7.3.4-ga5
    if (JavassistUtil.hasDeclaredField(ctClass, "_map")) {
      ctClass.getDeclaredMethod("handleGetObject").insertBefore(
          "if (jrMonitoredResource != null && jrMonitoredResource.modified()) {" +
          "  InputStream is = jrMonitoredResource.res.toURL().openConnection().getInputStream();" +
          "  try {" +
          "    Properties properties = PropertiesUtil.load(is, jrCharsetName);" +
          "    LanguageResources.fixValues(_map, properties);" +
          "  } finally {" +
          "    if (is != null) is.close();" +
          "  }"+
          "}"
      );
    }
    // 7.3.4-ga5 and later
    else {
      CtField f = JavassistUtil.getDeclaredField(ctClass, "_properties");
      if ((f.getModifiers() & Modifier.FINAL) != 0) {
        f.setModifiers(f.getModifiers() & ~Modifier.FINAL);
      }
      ctClass.getDeclaredMethod("handleGetObject").insertBefore(
          "if (jrMonitoredResource != null && jrMonitoredResource.modified()) {" +
          "  InputStream is = jrMonitoredResource.res.toURL().openConnection().getInputStream();" +
          "  try {" +
          "    _properties = PropertiesUtil.load(is, jrCharsetName);" +
          "  } finally {" +
          "    if (is != null) is.close();" +
          "  }"+
          "}"
      );
    }
  }
}