package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.NewExpr;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.LiferayPlugin;

import java.util.zip.ZipFile;

public class BaseAutoDeployListenerCBP extends CacheAwareJavassistClassBytecodeProcessor {

  private static final String JR_LOGGER =  "LoggerFactory.getLogger(\"" + LiferayPlugin.PRODUCT_PREFIX + "\")";

  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("java.io");
    cp.importPackage("java.util.zip");
    cp.importPackage("java.lang");

    cp.importPackage("org.zeroturnaround.javarebel");

    CtMethod method;
    try {
      method = ctClass.getDeclaredMethod("isMatchingFile");
    }
    catch (NotFoundException e) {
      return;
    }

    ctClass.addMethod(CtMethod.make("private static ZipFile jrOpenZipFileRec(File file, int counter) throws IOException {" +
        "    try {" +
        "      return new ZipFile(file);" +
        "    } catch (ZipException e) {" +
        "      if (counter < 5) {" +
        "        "+JR_LOGGER+".warn(\"Opening ZipFile \"+file.getAbsolutePath()+\" failed, retrying in \"+counter+\" seconds... \");" +
        "        try {" +
        "          Thread.sleep((long)counter*1000);" +
        "        } catch (InterruptedException e1) {" +
        "          return jrOpenZipFileRec(file, counter+1);" +
        "        }" +
        "        return jrOpenZipFileRec(file, counter+1);" +
        "      } else {" +
        "        throw e;" +
        "      }" +
        "    }" +
        "  }", ctClass));

    ctClass.addMethod(CtMethod.make("private static ZipFile jrOpenZipFile(File file) throws IOException {" +
        " return jrOpenZipFileRec(file, 2);" +
        "}", ctClass));

    method.instrument(new ExprEditor() {
      @Override
      public void edit(NewExpr e) throws CannotCompileException {
        if (ZipFile.class.getName().equals(e.getClassName())) {
          e.replace(" $_ = jrOpenZipFile($1);");
        }
      }
    });
  }
}