/**
 * Copyright (C) 2014 ZeroTurnaround OU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License v2 as published by
 * the Free Software Foundation, with the additional requirement that
 * ZeroTurnaround OU must be prominently attributed in the program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of GNU General Public License v2 from
 *   http://www.gnu.org/licenses/gpl-2.0.txt
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;

/**
 * Added to <code>com.liferay.faces.portal.el.I18N</code>.
 * Makes sure that the cache there would not work so that i18n file updates would be read again.
 * 
 * @author Andres Luuk
 */
public class I18NCBP extends CacheAwareJavassistClassBytecodeProcessor {

  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("org.zeroturnaround.javarebel");

    ctClass.addField(CtField.make("private long lastReset = System.currentTimeMillis();", ctClass));

    CtMethod method = ctClass.getDeclaredMethod("handleGetObject");
    method.insertBefore("" +
        "if (cacheHashMap != null && lastReset + ConfigurationFactory.getInstance().getCheckInterval() < System.currentTimeMillis()) {" +
        "  lastReset = System.currentTimeMillis();" +
        "  cacheHashMap.clear();" +
        "}");

    method.instrument(new ExprEditor() {
      public void edit(MethodCall m) throws CannotCompileException {
        if ("equals".equals(m.getMethodName())) {
          m.replace("" +
              "$_ = $proceed($$); " +
              "if (!$_) " +
              "  lastReset = System.currentTimeMillis();" +
              "");
        }
      }
    });
  }
}