package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.portlet.JrPortletContextImpl;

public class PortletContextImplCBP extends CacheAwareJavassistClassBytecodeProcessor {
  @Override
  public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
    ctClass.addInterface(classPool.get(JrPortletContextImpl.class.getName()));

    ctClass.addMethod(CtNewMethod.make("" +
        "public Object jrServletContext() {" +
        "  return getServletContext();" +
        "}", ctClass));
  }
}
