package org.zeroturnaround.jrebel.liferay.util;

import java.lang.reflect.Method;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.util.ReflectionUtil;
import org.zeroturnaround.jrebel.liferay.LiferayPlugin;

import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.Element;

public class XMLFormatter {
  private static final Logger jrLogger = LoggerFactory.getLogger(LiferayPlugin.PRODUCT_PREFIX);
  
  public static final String format(String xml) {
    if (xml == null) {
      return null;  
    }
    
    try {
      Document document = SAXReaderUtil.read(xml);
      final Method documentFormattedString = ReflectionUtil.getDeclaredMethod(Document.class, "formattedString");
      if (documentFormattedString != null) {
        return (String) documentFormattedString.invoke(document);
      }
      else {
        Element rootElement = document.getRootElement();
        return rootElement.formattedString();
      }
    }
    catch (Throwable e) {
      jrLogger.warn("Failed to format xml", e);
      return xml;
    }
  }
}
